import { world, system, EntityDamageCause } from "@minecraft/server"

world.beforeEvents.entityHurt.subscribe(data => {
    const { hurtEntity: { typeId }, damageSource: { cause } } = data
    if (cause !== EntityDamageCause.entityAttack ||
        typeId.startsWith("test")) return

    data.cancel = true
})
system.beforeEvents.startup.subscribe(({ itemComponentRegistry }) =>
    itemComponentRegistry.registerCustomComponent("test:beforedamage", {
        onHitEntity: ({ hitEntity, hadEffect }) =>
            console.error(`${hadEffect ? "Successfully" : "Failed to"} hit ${hitEntity.typeId}`)
    })
)